/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.DatabaseResultSet;
import oracle.ops.verification.framework.engine.task.DatabaseTaskException;
import oracle.ops.verification.framework.engine.task.Task;

public abstract class DatabaseTask
extends Task {
    private Version m_crsVer = null;
    private String[] m_databases = null;
    DBUtils m_dbUtils = null;
    private Map<String, OracleConnection> m_dbConMap = new HashMap<String, OracleConnection>();
    private Map<String, DatabaseConnectInfo> m_DbConInfoMap = new HashMap<String, DatabaseConnectInfo>();

    private static String[] getDatabases(Collection<DatabaseConnectInfo> dbConInfos) {
        String[] databases = new String[dbConInfos.size()];
        int i = 0;
        for (DatabaseConnectInfo dbConInfo : dbConInfos) {
            databases[i] = dbConInfo.dbUniqueName();
            ++i;
        }
        return databases;
    }

    public DatabaseTask(Version crsVer, Collection<DatabaseConnectInfo> dbConInfos) {
        super(DatabaseTask.getDatabases(dbConInfos), null, 1);
        this.m_crsVer = crsVer;
        this.m_databases = DatabaseTask.getDatabases(dbConInfos);
        this.m_dbUtils = new DBUtils(this.m_crsVer);
        this.m_resultSet = new DatabaseResultSet();
        for (DatabaseConnectInfo dbConInfo : dbConInfos) {
            this.m_DbConInfoMap.put(dbConInfo.dbUniqueName(), dbConInfo);
        }
    }

    public String[] databases() {
        return this.m_databases;
    }

    public synchronized OracleConnection getConnection(String dbUniqueName) throws DatabaseTaskException {
        OracleConnection conn = this.m_dbConMap.get(dbUniqueName);
        try {
            if (conn == null) {
                DatabaseConnectInfo dbConInfo = this.m_DbConInfoMap.get(dbUniqueName);
                String connectDescriptor = null;
                connectDescriptor = this.isPortRequiredForConnect(dbUniqueName) ? this.m_dbUtils.getConnectDescriptor(dbUniqueName, dbConInfo.listenerPort()) : this.m_dbUtils.getConnectDescriptor(dbUniqueName);
                conn = SQLFactory.getDBConnection((String)connectDescriptor, (String)dbConInfo.userName(), (String)dbConInfo.userPassword());
                this.m_dbConMap.put(dbUniqueName, conn);
            }
        }
        catch (DBUtilsException exDU) {
            Trace.out((String)("DBUtilsException occured. message: " + exDU.getMessage()));
            throw new DatabaseTaskException(exDU, s_gMsgBundle, "11115", dbUniqueName);
        }
        catch (DBConnectionException exDC) {
            Trace.out((String)("DBConnectionException occured. message: " + exDC.getMessage()));
            throw new DatabaseTaskException(exDC, s_gMsgBundle, "11115", dbUniqueName);
        }
        return conn;
    }

    private boolean isPortRequiredForConnect(String dbUniqueName) throws DatabaseTaskException {
        try {
            return this.m_dbUtils.isPortRequiredForConnect(dbUniqueName);
        }
        catch (DBUtilsException exDU) {
            throw new DatabaseTaskException(exDU);
        }
    }

    public DatabaseInfo getDatabaseInfo(String dbUniqueName) throws DatabaseTaskException {
        try {
            return this.m_dbUtils.getDatabaseInfo(dbUniqueName);
        }
        catch (DBUtilsException exDU) {
            throw new DatabaseTaskException(exDU);
        }
    }

    @Override
    public synchronized void clean() {
        for (String database : this.m_dbConMap.keySet()) {
            try {
                this.m_dbConMap.get(database).close();
            }
            catch (SQLException exSQL) {
                Trace.out((String)("SQLException while closing connection. message: " + exSQL.getMessage()));
                exSQL.printStackTrace();
            }
        }
        this.m_dbConMap.clear();
    }
}

